local _sqrt = math.sqrt

BubbleStamp = function(canvas, rect, max, value, paint)
    value = math.max(tonumber(value) or 0, 0)
    local size = math.min(rect.right - rect.left, rect.top - rect.bottom) / 2
    local cx = (rect.left + rect.right) / 2
    local cy = (rect.bottom + rect.top) / 2
    size = size * _sqrt(value / max)
    local path = Path.oval{
        left = cx - size,
        bottom = cy - size,
        right = cx + size,
        top = cy + size,
    }
    canvas:setPaint(paint):fill(path)
end

return BubbleStamp
